/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.client.Client;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.DropsTemplate;
import noppes.npcs.entity.data.AttributeSet;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.entity.data.EnchantSet;

public class DropController {
    private static DropController instance;
    private String filePath;
    public final Map<String, DropsTemplate> templates = new TreeMap<String, DropsTemplate>();

    public static DropController getInstance() {
        if (DropController.newInstance()) {
            instance = new DropController();
        }
        return instance;
    }

    private static boolean newInstance() {
        if (instance == null) {
            return true;
        }
        return CustomNpcs.Dir != null && !DropController.instance.filePath.equals(CustomNpcs.Dir.getAbsolutePath());
    }

    public DropController() {
        this.filePath = CustomNpcs.Dir.getAbsolutePath();
        instance = this;
    }

    public List<DropSet> getDrops(String saveDropsName) {
        ArrayList<DropSet> allDrops = new ArrayList<DropSet>();
        if (saveDropsName == null || saveDropsName.isEmpty() || !this.templates.containsKey(saveDropsName)) {
            return allDrops;
        }
        DropsTemplate template = this.templates.get(saveDropsName);
        if (template == null) {
            return allDrops;
        }
        return template.getDrops();
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtFile = new NBTTagCompound();
        NBTTagList templates = new NBTTagList();
        for (String template : this.templates.keySet()) {
            NBTTagCompound nbtTemplate = new NBTTagCompound();
            nbtTemplate.func_74778_a("Name", template);
            nbtTemplate.func_74782_a("Groups", (NBTBase)this.templates.get(template).getNBT());
            templates.func_74742_a((NBTBase)nbtTemplate);
        }
        nbtFile.func_74782_a("Templates", (NBTBase)templates);
        return nbtFile;
    }

    private void loadDefaultDrops() {
        NpcAPI api = NpcAPI.Instance();
        if (api == null) {
            return;
        }
        DropsTemplate temp = new DropsTemplate();
        temp.groups.put(0, new TreeMap());
        DropSet ds0 = new DropSet(null);
        ds0.amount[0] = 5;
        ds0.amount[1] = 8;
        ds0.chance = 72.5;
        ds0.item = api.getIItemStack(new ItemStack(Items.field_151044_h));
        ds0.pos = 0;
        temp.groups.get(0).put(0, ds0);
        DropSet ds1 = new DropSet(null);
        ds1.amount[0] = 2;
        ds1.amount[1] = 5;
        ds1.chance = 8.0;
        ds1.item = api.getIItemStack(new ItemStack(Items.field_151042_j));
        ds1.pos = 1;
        temp.groups.get(0).put(1, ds1);
        DropSet ds2 = new DropSet(null);
        ds2.amount[0] = 1;
        ds2.amount[1] = 3;
        ds2.chance = 4.3333;
        ds2.item = api.getIItemStack(new ItemStack(Items.field_151043_k));
        ds2.pos = 2;
        temp.groups.get(0).put(2, ds2);
        DropSet ds3 = new DropSet(null);
        ds3.amount[0] = 1;
        ds3.amount[1] = 2;
        ds3.chance = 0.575;
        ds3.item = api.getIItemStack(new ItemStack(Items.field_151045_i));
        ds3.pos = 3;
        temp.groups.get(0).put(3, ds3);
        temp.groups.put(1, new TreeMap());
        DropSet df0 = new DropSet(null);
        df0.amount[0] = 1;
        df0.amount[1] = 1;
        df0.chance = 2.5;
        df0.item = api.getIItemStack(new ItemStack(Items.field_151036_c));
        df0.pos = 0;
        EnchantSet ench0 = (EnchantSet)df0.addEnchant(Enchantment.func_180305_b((String)"unbreaking"));
        ench0.setChance(50.0);
        ench0.setLevels(1, 5);
        AttributeSet attr = (AttributeSet)df0.addAttribute(SharedMonsterAttributes.field_111264_e.func_111108_a());
        attr.setChance(25.0);
        attr.setValues(1.0, 3.0);
        attr.setSlot(0);
        df0.addDropNbtSet(8, 12.5, "display.Name", new String[]{"Sword", "Axe"});
        temp.groups.get(1).put(0, df0);
        this.templates.put("default", temp);
        this.save();
    }

    public void loadFile() {
        CustomNpcs.debugData.start(null);
        LogWriter.info("Loading Drops");
        this.filePath = CustomNpcs.Dir.getAbsolutePath();
        try {
            File file = new File(CustomNpcs.Dir, "drops.dat");
            if (file.exists()) {
                try {
                    NBTTagCompound nbtFile = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]));
                    this.loadNBTData(nbtFile);
                }
                catch (IOException e) {
                    LogWriter.error(e);
                }
            } else {
                this.templates.clear();
                this.loadDefaultDrops();
            }
        }
        catch (Exception e) {
            LogWriter.error(e);
            try {
                File file2 = new File(CustomNpcs.Dir, "recipes.dat_old");
                if (file2.exists()) {
                    try {
                        NBTTagCompound nbtFile = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(file2.toPath(), new OpenOption[0]));
                        this.loadNBTData(nbtFile);
                    }
                    catch (IOException err) {
                        LogWriter.error(err);
                    }
                }
            }
            catch (Exception ee) {
                LogWriter.error(ee);
            }
        }
        CustomNpcs.debugData.end(null);
    }

    public void loadNBTData(NBTTagCompound nbtFile) {
        this.templates.clear();
        if (nbtFile.func_150297_b("Templates", 9)) {
            for (int i = 0; i < nbtFile.func_150295_c("Templates", 10).func_74745_c(); ++i) {
                NBTTagCompound nbtTemplate = nbtFile.func_150295_c("Templates", 10).func_150305_b(i);
                if (!nbtTemplate.func_150297_b("Name", 8)) continue;
                this.templates.put(nbtTemplate.func_74779_i("Name"), new DropsTemplate(nbtTemplate.func_74775_l("Groups")));
            }
        }
        if (this.templates.isEmpty()) {
            this.loadDefaultDrops();
        }
    }

    public void save() {
        CustomNpcs.debugData.start(null);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.getNBT(), (OutputStream)Files.newOutputStream(new File(CustomNpcs.Dir, "drops.dat").toPath(), new OpenOption[0]));
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        CustomNpcs.debugData.end(null);
    }

    public void sendTo(EntityPlayerMP player) {
        if (this.templates.isEmpty()) {
            this.loadDefaultDrops();
        }
        TreeMap<String, DropsTemplate> tempMap = new TreeMap<String, DropsTemplate>(this.templates);
        Server.sendData(player, EnumPacketClient.DROP_GROUP_DATA, new NBTTagCompound());
        for (String template : tempMap.keySet()) {
            NBTTagCompound nbtTemplate = new NBTTagCompound();
            nbtTemplate.func_74778_a("Name", template);
            nbtTemplate.func_74782_a("Groups", (NBTBase)((DropsTemplate)tempMap.get(template)).getNBT());
            Server.sendData(player, EnumPacketClient.DROP_GROUP_DATA, nbtTemplate);
        }
        Server.sendData(player, EnumPacketClient.GUI_UPDATE, new Object[0]);
    }

    public void sendToServer(String dropTemplate) {
        if (this.templates.containsKey(dropTemplate)) {
            NBTTagCompound nbtTemplate = new NBTTagCompound();
            nbtTemplate.func_74778_a("Name", dropTemplate);
            nbtTemplate.func_74782_a("Groups", (NBTBase)this.templates.get(dropTemplate).getNBT());
            Client.sendDirectData(EnumPacketServer.DropTemplateSave, 1, nbtTemplate);
            return;
        }
        Client.sendDirectData(EnumPacketServer.DropTemplateSave, 0);
        TreeMap<String, DropsTemplate> tempMap = new TreeMap<String, DropsTemplate>(this.templates);
        for (String template : tempMap.keySet()) {
            NBTTagCompound nbtTemplate = new NBTTagCompound();
            nbtTemplate.func_74778_a("Name", template);
            nbtTemplate.func_74782_a("Groups", (NBTBase)((DropsTemplate)tempMap.get(template)).getNBT());
            Client.sendDirectData(EnumPacketServer.DropTemplateSave, 1, nbtTemplate);
        }
    }
}

